/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.autoupdate;

import com.quantumdata.autoupdate.AutoUpdateGUI;
import com.quantumdata.autoupdate.Device88X;
import com.quantumdata.autoupdate.Device88XException;
import com.quantumdata.autoupdate.UpgradeScreen;
import com.quantumdata.ftp.CoFile;
import com.quantumdata.ftp.Ftp;
import com.quantumdata.ftp.FtpConnect;
import com.quantumdata.ftp.FtpFile;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class IPUpgradeScreen
extends UpgradeScreen {
    private final String btnCancelCmd = "CANCEL";
    private final String btnTestNextCmd = "NEXT_TEST";
    private final String btnTestBootRomCmd = "BOOT_ROM_TEST";
    private final String doneCmd = "DONE";
    private JProgressBar m_progressBar;
    private Device88X m_Dev88X;
    private Action m_act;
    private Thread m_netThread;
    private JLabel m_txtInstruction;
    private FtpConnect m_ftpCon;
    private Ftp m_generator;

    public IPUpgradeScreen(String string, AutoUpdateGUI autoUpdateGUI) {
        super(string, autoUpdateGUI);
        this.configureJFrame(autoUpdateGUI);
    }

    protected void finalize() {
        System.out.println("Destroying IP Get Genstats Window");
        super.finalize();
        this.m_progressBar = null;
    }

    private void configureJFrame(ActionListener actionListener) {
        Container container = super.getJFrame().getContentPane();
        this.m_txtInstruction = new JLabel("<html><body><p align=\"center\">Performing an Upgrade on your 88X Generator.</p></body></html>");
        this.m_act = new UpgradeScreen.AutomaticActionEvent(this, actionListener);
        this.m_progressBar = new JProgressBar(0, 100);
        this.m_progressBar.setIndeterminate(false);
        this.m_progressBar.setValue(0);
        this.m_progressBar.setPreferredSize(new Dimension(500, 20));
        JButton jButton = new JButton("Cancel");
        jButton.setVerticalTextPosition(0);
        jButton.setHorizontalTextPosition(10);
        jButton.setMnemonic('C');
        jButton.setActionCommand("CANCEL");
        jButton.addActionListener(actionListener);
        JButton jButton2 = new JButton("Next (Screen Test)");
        jButton2.setVerticalTextPosition(0);
        jButton2.setHorizontalTextPosition(10);
        jButton2.setMnemonic('N');
        jButton2.setActionCommand("NEXT_TEST");
        jButton2.addActionListener(actionListener);
        jButton2.setVisible(false);
        JButton jButton3 = new JButton("Boot Rom Upgrade (Screen Test)");
        jButton3.setVerticalTextPosition(0);
        jButton3.setHorizontalTextPosition(10);
        jButton3.setMnemonic('B');
        jButton3.setActionCommand("BOOT_ROM_TEST");
        jButton3.addActionListener(actionListener);
        jButton3.setVisible(false);
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        int n = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 0, n, 4);
        gridBagConstraints.anchor = 21;
        gridBagLayout.setConstraints(this.m_txtInstruction, gridBagConstraints);
        jPanel.add(this.m_txtInstruction);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, n, 4);
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.m_progressBar, gridBagConstraints);
        jPanel.add(this.m_progressBar);
        JPanel jPanel2 = new JPanel();
        super.setLogo(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jPanel3.add(jButton3);
        container.add((Component)jPanel2, "First");
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel3, "Last");
        container.validate();
    }

    public int ScreenHandler(ActionEvent actionEvent, int n, Device88X device88X) {
        int n2 = n;
        if ("CANCEL".equals(actionEvent.getActionCommand())) {
            System.out.println("Exiting");
            System.exit(0);
        } else if ("DONE".equalsIgnoreCase(actionEvent.getActionCommand())) {
            n2 = 10;
            System.out.println("Going to next Screen: ID=" + n2);
        }
        return n2;
    }

    public void refresh() {
        super.refresh();
    }

    public void run(Device88X device88X) {
        this.m_Dev88X = device88X;
        this.m_netThread = new Thread(new runIPUpgrade(super.getJFrame()));
        this.m_netThread.setName("IP Upgrade Thread");
        this.m_netThread.start();
    }

    private synchronized void backupFiles(Ftp ftp, String string) throws IOException {
        int n = -1;
        String string2 = ftp.pwd();
        CoFile[] coFileArray = new FtpFile(string2, this.m_generator).listCoFiles();
        this.m_progressBar.setMaximum(coFileArray.length);
        for (int i = 0; i < coFileArray.length; ++i) {
            Object[] objectArray;
            String string3 = string + File.separator + coFileArray[i].getName();
            this.m_txtInstruction.setText("Backing up: " + coFileArray[i].getAbsolutePath());
            System.out.println("\r\n" + coFileArray[i].getAbsolutePath() + " -> " + string3);
            if (coFileArray[i].isDirectory()) {
                new File(string3).mkdirs();
                ftp.cd(coFileArray[i].getName());
                this.m_progressBar.setIndeterminate(true);
                this.m_txtInstruction.setText("Retrieving Directory Listing for: " + coFileArray[i].getAbsolutePath());
                this.backupFiles(ftp, string + "/" + coFileArray[i].getName());
                Thread.yield();
                ftp.cdup();
                continue;
            }
            this.m_progressBar.setMaximum((int)coFileArray[i].length());
            this.m_progressBar.setIndeterminate(false);
            try {
                this.m_Dev88X.copyInputStream(coFileArray[i].getInputStream(), new BufferedOutputStream(new FileOutputStream(string3)), this.m_txtInstruction, this.m_progressBar);
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                objectArray = new Object[]{"Continue", "Cancel Upgrage"};
                System.err.println("File Not Found Error: " + fileNotFoundException.getMessage());
                n = JOptionPane.showOptionDialog(null, "File Not Found " + fileNotFoundException.getMessage() + "\nContinue with backup?", "File Not Found", 1, 0, null, objectArray, objectArray[0]);
                if (n == 0) continue;
                this.m_generator.disconnect();
                System.exit(0);
                continue;
            }
            catch (IOException iOException) {
                objectArray = new Object[]{"Continue", "Cancel Upgrage"};
                System.err.println("IO Error: " + iOException.getMessage());
                n = JOptionPane.showOptionDialog(null, "IO Error: " + iOException.getMessage() + "\nContinue with backup?", "IO Error", 1, 0, null, objectArray, objectArray[0]);
                if (n == 0) continue;
                this.m_generator.disconnect();
                System.exit(0);
            }
        }
    }

    private synchronized void clear88XFiles(Ftp ftp) throws IOException {
        String string = ftp.pwd();
        CoFile[] coFileArray = new FtpFile(string, this.m_generator).listCoFiles();
        this.m_progressBar.setIndeterminate(true);
        for (int i = 0; i < coFileArray.length; ++i) {
            if (coFileArray[i].isDirectory()) {
                ftp.cd(coFileArray[i].getName());
                this.m_txtInstruction.setText("Retrieving Directory Listing for: " + coFileArray[i].getAbsolutePath());
                this.clear88XFiles(ftp);
                Thread.yield();
                ftp.cdup();
                coFileArray[i].delete();
                continue;
            }
            this.m_txtInstruction.setText("Deleting " + coFileArray[i].getAbsolutePath() + " From The Generator");
            coFileArray[i].delete();
        }
    }

    private synchronized void transferFiles(Ftp ftp, String string) throws IOException {
        String string2 = null;
        File[] fileArray = new File(string).listFiles();
        String string3 = null;
        String string4 = null;
        string2 = ftp.pwd();
        for (int i = 0; i < fileArray.length; ++i) {
            string3 = string2 + "/" + fileArray[i].getName();
            string4 = string + File.separator + fileArray[i].getName();
            if (fileArray[i].getName().endsWith("bootrom_uncmp.hex")) continue;
            System.out.println("\r\n" + string4 + " -> " + string3);
            if (fileArray[i].isDirectory()) {
                ftp.mkdir(string3);
                ftp.cd(string3);
                this.transferFiles(ftp, string4);
                ftp.cdup();
            } else {
                this.m_progressBar.setMaximum((int)fileArray[i].length());
                this.m_progressBar.setIndeterminate(false);
                this.m_txtInstruction.setText("Transferring: " + string3);
                this.m_Dev88X.copyInputStream(new BufferedInputStream(new FileInputStream(fileArray[i])), new FtpFile(string3, ftp).getOutputStream(), this.m_txtInstruction, this.m_progressBar);
            }
            Thread.yield();
        }
    }

    private synchronized void transferBootRomImage(Ftp ftp, String string) throws IOException {
        ftp.cd("/card0/System");
        FtpFile ftpFile = new FtpFile("/card0/System", ftp);
        if (!ftpFile.exists()) {
            ftpFile.mkdirs();
        }
        String string2 = "/card0/System/bootrom_uncmp.hex";
        String string3 = string + File.separator + "System" + File.separator + "bootrom_uncmp.hex";
        this.m_txtInstruction.setText("Transferring: " + string2);
        this.m_progressBar.setIndeterminate(false);
        this.m_Dev88X.copyInputStream(new BufferedInputStream(new FileInputStream(string3)), new FtpFile(string2, ftp).getOutputStream(), this.m_txtInstruction, this.m_progressBar);
        Thread.yield();
        System.out.println("Flashing Boot ROM");
        this.m_txtInstruction.setText("Flashing Boot ROM... Please Wait");
        this.m_progressBar.setIndeterminate(true);
        if (!this.m_Dev88X.sendFlashBootRomCmd(30000)) {
            IOException iOException = new IOException("Error Flashing Boot ROM");
            throw iOException;
        }
    }

    private synchronized boolean checkFreeSpace(Ftp ftp, Device88X device88X) throws IOException {
        long l = 0L;
        long l2 = device88X.getTotalUpgradeBytes();
        try {
            l = device88X.getFlashFreeSpace(5000);
        }
        catch (Device88XException device88XException) {
            return true;
        }
        System.out.println("Total Bytes Needed: " + l2 / 1000L + " Kb");
        System.out.println("Free Space on Card: " + l / 1000L + " Kb");
        return l > l2;
    }

    class runIPUpgrade
    implements Runnable {
        private JFrame runFrame;

        public runIPUpgrade(JFrame jFrame) {
            this.runFrame = jFrame;
        }

        private void ConnectToGenerator() throws IOException {
            int n;
            do {
                if (!IPUpgradeScreen.this.m_generator.connect(IPUpgradeScreen.this.m_ftpCon)) {
                    Object[] objectArray = new Object[]{"Retry", "Cancel Upgrade"};
                    n = JOptionPane.showOptionDialog(this.runFrame, "Could not find " + IPUpgradeScreen.this.m_Dev88X.getIPAddress() + "\nPlease plug the 88X into the network", "Host Not Found", 1, 2, null, objectArray, objectArray[0]);
                    if (n != 1) continue;
                    IPUpgradeScreen.this.m_generator.disconnect();
                    System.out.println("Exiting");
                    System.exit(0);
                    continue;
                }
                n = -2;
            } while (n == 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            int n = -1;
            ActionEvent actionEvent = new ActionEvent(this, 1001, "DONE");
            IPUpgradeScreen.this.m_act.setEnabled(true);
            IPUpgradeScreen.this.m_txtInstruction.setText("Backing Up Files from Generator to this Computer");
            IPUpgradeScreen.this.m_ftpCon = new FtpConnect();
            IPUpgradeScreen.this.m_generator = new Ftp();
            IPUpgradeScreen.this.m_ftpCon.setHostName(IPUpgradeScreen.this.m_Dev88X.getIPAddress());
            IPUpgradeScreen.this.m_ftpCon.setUserName("");
            IPUpgradeScreen.this.m_ftpCon.setPassWord("");
            try {
                this.ConnectToGenerator();
                if (!IPUpgradeScreen.this.m_Dev88X.isSkipBackupFlagSet()) {
                    IPUpgradeScreen.this.m_generator.cd("/tffs0");
                    this.runFrame.setTitle("Backing Up Files From Generator");
                    System.out.println("===== Backing Up Files From The Generator =====");
                    IPUpgradeScreen.this.backupFiles(IPUpgradeScreen.this.m_generator, IPUpgradeScreen.this.m_Dev88X.getBackupDir());
                }
                Thread.yield();
                IPUpgradeScreen.this.m_generator.disconnect();
                Thread.yield();
                if (!IPUpgradeScreen.this.m_Dev88X.isSkipBackupFlagSet()) {
                    IPUpgradeScreen.this.m_txtInstruction.setText("Diffing between the backup files and upgrade files");
                    this.runFrame.setTitle("Diff Files Between Backup and Upgrade Files");
                    System.out.println("===== Diff Dir Structure between the backup files to the upgrade files =====");
                    long l = IPUpgradeScreen.this.m_Dev88X.diffFileStructure(IPUpgradeScreen.this.m_Dev88X.getBackupDir(), IPUpgradeScreen.this.m_Dev88X.getUnzippedPath(), IPUpgradeScreen.this.m_txtInstruction, IPUpgradeScreen.this.m_progressBar);
                    IPUpgradeScreen.this.m_Dev88X.setTotalUpgradeBytes(l);
                }
                this.ConnectToGenerator();
                IPUpgradeScreen.this.m_txtInstruction.setText("Clear 88X Files");
                this.runFrame.setTitle("Clear Old Files From Generator");
                System.out.println("===== Clear Old Files From The Generator =====");
                IPUpgradeScreen.this.m_generator.cd("/tffs0");
                IPUpgradeScreen.this.clear88XFiles(IPUpgradeScreen.this.m_generator);
                n = -1;
                this.runFrame.setTitle("Check the Generator Free Space");
                System.out.println("===== Check the Generator Free Space =====");
                while (!IPUpgradeScreen.this.checkFreeSpace(IPUpgradeScreen.this.m_generator, IPUpgradeScreen.this.m_Dev88X)) {
                    Object[] objectArray = new Object[]{"Retry", "Cancel Upgrade"};
                    n = JOptionPane.showOptionDialog(this.runFrame, "Not Enough Space Available on the Generator's Flash\nPlease delete some files on the Generator's Flash (/tffs0) card \nto make room for the upgrade files", "Not Enough Space On Flash", 1, 2, null, objectArray, objectArray[0]);
                    if (n == 1) {
                        IPUpgradeScreen.this.m_txtInstruction.setText("Restoring Backup Files");
                        IPUpgradeScreen.this.m_generator.cd("/tffs0");
                        IPUpgradeScreen.this.transferFiles(IPUpgradeScreen.this.m_generator, IPUpgradeScreen.this.m_Dev88X.getBackupDir());
                        IPUpgradeScreen.this.m_generator.disconnect();
                        System.out.println("Exiting");
                        System.exit(0);
                    }
                    if (n < 0) continue;
                }
                IPUpgradeScreen.this.m_txtInstruction.setText("Transfer the Upgrade Files");
                IPUpgradeScreen.this.m_generator.cd("/tffs0");
                this.runFrame.setTitle("Transfer New Files to Generator");
                System.out.println("===== Transfer New Files to Generator =====");
                IPUpgradeScreen.this.transferFiles(IPUpgradeScreen.this.m_generator, IPUpgradeScreen.this.m_Dev88X.getUnzippedPath());
                if (IPUpgradeScreen.this.m_Dev88X.getBootRomUpgradeFlag()) {
                    this.runFrame.setTitle("Transfer Boot ROM to Generator");
                    System.out.println("===== Transfer Boot ROM image to the Generator =====");
                    IPUpgradeScreen.this.transferBootRomImage(IPUpgradeScreen.this.m_generator, IPUpgradeScreen.this.m_Dev88X.getUnzippedPath());
                }
                this.runFrame.setTitle("Cleaning Up Install Files");
                System.out.println("===== Install Complete, Cleaning Up Unzipped Folder =====");
                IPUpgradeScreen.this.m_Dev88X.deleteFolder(IPUpgradeScreen.this.m_Dev88X.getUnzippedPath(), IPUpgradeScreen.this.m_txtInstruction, IPUpgradeScreen.this.m_progressBar);
                File file = new File(IPUpgradeScreen.this.m_Dev88X.getUnzippedPath());
                file.delete();
                IPUpgradeScreen.this.m_Dev88X.setUnzippedPath("");
            }
            catch (IOException iOException) {
                IPUpgradeScreen.this.m_generator.disconnect();
                System.err.println("Error: " + iOException.getMessage());
                JOptionPane.showMessageDialog(null, "Upgrade Error:  " + iOException.getMessage(), "Upgrade Error", 0);
                System.exit(0);
            }
            finally {
                IPUpgradeScreen.this.m_generator.disconnect();
            }
            IPUpgradeScreen.this.m_act.actionPerformed(actionEvent);
        }
    }
}

